#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgUnitDataReportCriteria
	/// </summary>
	public class DlgUnitDataReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpSections;
		private System.Windows.Forms.GroupBox grpImage1;
		private System.Windows.Forms.Button btnCheckAll;
		private System.Windows.Forms.Button btnUncheckAll;
		private System.Windows.Forms.PictureBox pictureBox1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private System.Windows.Forms.CheckBox cbModification;
		private System.Windows.Forms.CheckBox cbTransfusion;
		private System.Windows.Forms.CheckBox cbIssue;
		private System.Windows.Forms.CheckBox cbFinance;
		private System.Windows.Forms.CheckBox cbCrossmatchTesting;
		private System.Windows.Forms.CheckBox cbOutgoingShipment;
		private System.Windows.Forms.CheckBox cbExceptionReport;
		private System.Windows.Forms.CheckBox cbUnitTesting;
		private System.Windows.Forms.CheckBox cbPatientAssociation;
		private System.Windows.Forms.CheckBox cbUnitStatus;
		private System.Windows.Forms.CheckBox cbIncomingShipment;
		private System.Windows.Forms.CheckBox cbAntigenTyping;
		private System.Windows.Forms.CheckBox cbRestrictedPatient;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// 		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgUnitDataReportCriteria));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpSections = new System.Windows.Forms.GroupBox();
			this.cbRestrictedPatient = new System.Windows.Forms.CheckBox();
			this.cbAntigenTyping = new System.Windows.Forms.CheckBox();
			this.btnCheckAll = new System.Windows.Forms.Button();
			this.btnUncheckAll = new System.Windows.Forms.Button();
			this.cbCrossmatchTesting = new System.Windows.Forms.CheckBox();
			this.cbOutgoingShipment = new System.Windows.Forms.CheckBox();
			this.cbExceptionReport = new System.Windows.Forms.CheckBox();
			this.cbModification = new System.Windows.Forms.CheckBox();
			this.cbUnitTesting = new System.Windows.Forms.CheckBox();
			this.cbTransfusion = new System.Windows.Forms.CheckBox();
			this.cbIssue = new System.Windows.Forms.CheckBox();
			this.cbPatientAssociation = new System.Windows.Forms.CheckBox();
			this.cbFinance = new System.Windows.Forms.CheckBox();
			this.cbUnitStatus = new System.Windows.Forms.CheckBox();
			this.cbIncomingShipment = new System.Windows.Forms.CheckBox();
			this.grpImage1 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpSections.SuspendLayout();
			this.grpImage1.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Unit History Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(532, 340);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(612, 340);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpSections
			// 
			this.grpSections.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSections.Controls.Add(this.cbRestrictedPatient);
			this.grpSections.Controls.Add(this.cbAntigenTyping);
			this.grpSections.Controls.Add(this.btnCheckAll);
			this.grpSections.Controls.Add(this.btnUncheckAll);
			this.grpSections.Controls.Add(this.cbCrossmatchTesting);
			this.grpSections.Controls.Add(this.cbOutgoingShipment);
			this.grpSections.Controls.Add(this.cbExceptionReport);
			this.grpSections.Controls.Add(this.cbModification);
			this.grpSections.Controls.Add(this.cbUnitTesting);
			this.grpSections.Controls.Add(this.cbTransfusion);
			this.grpSections.Controls.Add(this.cbIssue);
			this.grpSections.Controls.Add(this.cbPatientAssociation);
			this.grpSections.Controls.Add(this.cbFinance);
			this.grpSections.Controls.Add(this.cbUnitStatus);
			this.grpSections.Controls.Add(this.cbIncomingShipment);
			this.grpSections.Location = new System.Drawing.Point(324, 32);
			this.grpSections.Name = "grpSections";
			this.grpSections.Size = new System.Drawing.Size(364, 184);
			this.grpSections.TabIndex = 1;
			this.grpSections.TabStop = false;
			this.grpSections.Text = "Include Report Sections*";
			// 
			// cbRestrictedPatient
			// 
			this.cbRestrictedPatient.Checked = true;
			this.cbRestrictedPatient.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbRestrictedPatient.Location = new System.Drawing.Point(8, 88);
			this.cbRestrictedPatient.Name = "cbRestrictedPatient";
			this.cbRestrictedPatient.Size = new System.Drawing.Size(164, 20);
			this.cbRestrictedPatient.TabIndex = 3;
			this.cbRestrictedPatient.Text = "&Restricted Patient";
			this.cbRestrictedPatient.CheckedChanged += new System.EventHandler(this.cbRestrictedPatient_CheckedChanged);
			// 
			// cbAntigenTyping
			// 
			this.cbAntigenTyping.Checked = true;
			this.cbAntigenTyping.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbAntigenTyping.Location = new System.Drawing.Point(8, 64);
			this.cbAntigenTyping.Name = "cbAntigenTyping";
			this.cbAntigenTyping.Size = new System.Drawing.Size(164, 20);
			this.cbAntigenTyping.TabIndex = 2;
			this.cbAntigenTyping.Text = "&Antigen Typing";
			this.cbAntigenTyping.CheckedChanged += new System.EventHandler(this.cbAntigenTyping_CheckedChanged);
			// 
			// btnCheckAll
			// 
			this.btnCheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnCheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnCheckAll.Image")));
			this.btnCheckAll.Location = new System.Drawing.Point(340, 0);
			this.btnCheckAll.Name = "btnCheckAll";
			this.btnCheckAll.Size = new System.Drawing.Size(16, 16);
			this.btnCheckAll.TabIndex = 14;
			this.btnCheckAll.Click += new System.EventHandler(this.btnCheckAll_Click);
			// 
			// btnUncheckAll
			// 
			this.btnUncheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnUncheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnUncheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnUncheckAll.Image")));
			this.btnUncheckAll.Location = new System.Drawing.Point(324, 0);
			this.btnUncheckAll.Name = "btnUncheckAll";
			this.btnUncheckAll.Size = new System.Drawing.Size(16, 16);
			this.btnUncheckAll.TabIndex = 13;
			this.btnUncheckAll.Click += new System.EventHandler(this.btnUncheckAll_Click);
			// 
			// cbCrossmatchTesting
			// 
			this.cbCrossmatchTesting.Checked = true;
			this.cbCrossmatchTesting.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbCrossmatchTesting.Location = new System.Drawing.Point(180, 64);
			this.cbCrossmatchTesting.Name = "cbCrossmatchTesting";
			this.cbCrossmatchTesting.Size = new System.Drawing.Size(172, 20);
			this.cbCrossmatchTesting.TabIndex = 9;
			this.cbCrossmatchTesting.Text = "Crossmatch Testin&g Details";
			this.cbCrossmatchTesting.CheckedChanged += new System.EventHandler(this.cbCrossmatchTesting_CheckedChanged);
			// 
			// cbOutgoingShipment
			// 
			this.cbOutgoingShipment.Checked = true;
			this.cbOutgoingShipment.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbOutgoingShipment.Location = new System.Drawing.Point(8, 40);
			this.cbOutgoingShipment.Name = "cbOutgoingShipment";
			this.cbOutgoingShipment.Size = new System.Drawing.Size(168, 20);
			this.cbOutgoingShipment.TabIndex = 1;
			this.cbOutgoingShipment.Text = "O&utgoing Shipment Details";
			this.cbOutgoingShipment.CheckedChanged += new System.EventHandler(this.cbOutgoingShipment_CheckedChanged);
			// 
			// cbExceptionReport
			// 
			this.cbExceptionReport.Location = new System.Drawing.Point(180, 160);
			this.cbExceptionReport.Name = "cbExceptionReport";
			this.cbExceptionReport.Size = new System.Drawing.Size(164, 20);
			this.cbExceptionReport.TabIndex = 12;
			this.cbExceptionReport.Text = "E&xception Report Entries";
			this.cbExceptionReport.CheckedChanged += new System.EventHandler(this.cbExceptionReport_CheckedChanged);
			// 
			// cbModification
			// 
			this.cbModification.Checked = true;
			this.cbModification.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbModification.Location = new System.Drawing.Point(180, 88);
			this.cbModification.Name = "cbModification";
			this.cbModification.Size = new System.Drawing.Size(164, 20);
			this.cbModification.TabIndex = 10;
			this.cbModification.Text = "&Modification History";
			this.cbModification.CheckedChanged += new System.EventHandler(this.cbModification_CheckedChanged);
			// 
			// cbUnitTesting
			// 
			this.cbUnitTesting.Checked = true;
			this.cbUnitTesting.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbUnitTesting.Location = new System.Drawing.Point(180, 40);
			this.cbUnitTesting.Name = "cbUnitTesting";
			this.cbUnitTesting.Size = new System.Drawing.Size(164, 20);
			this.cbUnitTesting.TabIndex = 8;
			this.cbUnitTesting.Text = "Unit Testing &Details";
			this.cbUnitTesting.CheckedChanged += new System.EventHandler(this.cbUnitTesting_CheckedChanged);
			// 
			// cbTransfusion
			// 
			this.cbTransfusion.Checked = true;
			this.cbTransfusion.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbTransfusion.Location = new System.Drawing.Point(180, 112);
			this.cbTransfusion.Name = "cbTransfusion";
			this.cbTransfusion.Size = new System.Drawing.Size(164, 20);
			this.cbTransfusion.TabIndex = 11;
			this.cbTransfusion.Text = "&Transfusion Details";
			this.cbTransfusion.CheckedChanged += new System.EventHandler(this.cbTransfusion_CheckedChanged);
			// 
			// cbIssue
			// 
			this.cbIssue.Checked = true;
			this.cbIssue.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbIssue.Location = new System.Drawing.Point(180, 16);
			this.cbIssue.Name = "cbIssue";
			this.cbIssue.Size = new System.Drawing.Size(164, 20);
			this.cbIssue.TabIndex = 7;
			this.cbIssue.Text = "Issu&e History";
			this.cbIssue.CheckedChanged += new System.EventHandler(this.cbIssue_CheckedChanged);
			// 
			// cbPatientAssociation
			// 
			this.cbPatientAssociation.Checked = true;
			this.cbPatientAssociation.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbPatientAssociation.Location = new System.Drawing.Point(8, 160);
			this.cbPatientAssociation.Name = "cbPatientAssociation";
			this.cbPatientAssociation.Size = new System.Drawing.Size(168, 20);
			this.cbPatientAssociation.TabIndex = 6;
			this.cbPatientAssociation.Text = "&Patient Association History";
			this.cbPatientAssociation.CheckedChanged += new System.EventHandler(this.cbPatientAssociation_CheckedChanged);
			// 
			// cbFinance
			// 
			this.cbFinance.Checked = true;
			this.cbFinance.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbFinance.Location = new System.Drawing.Point(8, 136);
			this.cbFinance.Name = "cbFinance";
			this.cbFinance.Size = new System.Drawing.Size(164, 20);
			this.cbFinance.TabIndex = 5;
			this.cbFinance.Text = "&Finance Details";
			this.cbFinance.CheckedChanged += new System.EventHandler(this.cbFinance_CheckedChanged);
			// 
			// cbUnitStatus
			// 
			this.cbUnitStatus.Checked = true;
			this.cbUnitStatus.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbUnitStatus.Location = new System.Drawing.Point(8, 112);
			this.cbUnitStatus.Name = "cbUnitStatus";
			this.cbUnitStatus.Size = new System.Drawing.Size(164, 20);
			this.cbUnitStatus.TabIndex = 4;
			this.cbUnitStatus.Text = "&Quarantine Details";
			this.cbUnitStatus.CheckedChanged += new System.EventHandler(this.cbUnitStatus_CheckedChanged);
			// 
			// cbIncomingShipment
			// 
			this.cbIncomingShipment.Checked = true;
			this.cbIncomingShipment.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbIncomingShipment.Location = new System.Drawing.Point(8, 16);
			this.cbIncomingShipment.Name = "cbIncomingShipment";
			this.cbIncomingShipment.Size = new System.Drawing.Size(168, 20);
			this.cbIncomingShipment.TabIndex = 0;
			this.cbIncomingShipment.Text = "&Incoming Shipment Details";
			this.cbIncomingShipment.CheckedChanged += new System.EventHandler(this.cbIncomingShipment_CheckedChanged);
			// 
			// grpImage1
			// 
			this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage1.Controls.Add(this.pictureBox1);
			this.grpImage1.Location = new System.Drawing.Point(4, 32);
			this.grpImage1.Name = "grpImage1";
			this.grpImage1.Size = new System.Drawing.Size(52, 304);
			this.grpImage1.TabIndex = 6;
			this.grpImage1.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// bloodUnitSelectorVertical1
			// 
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
			this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(60, 32);
			this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
			this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 304);
			this.bloodUnitSelectorVertical1.TabIndex = 0;
			this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_SearchBtnClick);
			this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelectorVertical1_UnitUpdated);
			this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_ClearBtnClick);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(324, 216);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(364, 120);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.rdoCreateNow_CheckedChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(348, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			this.grpScheduleJob.Text = "grpScheduleJob";
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(244, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(244, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// DlgUnitDataReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(692, 373);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.bloodUnitSelectorVertical1);
			this.Controls.Add(this.grpImage1);
			this.Controls.Add(this.grpSections);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Unit_History_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(700, 400);
			this.Name = "DlgUnitDataReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Unit History Report";
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpSections, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage1, 0);
			this.Controls.SetChildIndex(this.bloodUnitSelectorVertical1, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.grpSections.ResumeLayout(false);
			this.grpImage1.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Variables

		private const string _checkBoxType = "System.Windows.Forms.CheckBox";

		private BOL.BloodUnitReport _bloodUnitReport;

		#endregion

		#region Properties

		/// <summary>
		/// BloodUnitReport
		/// </summary>
		public BloodUnitReport BloodUnitReport
		{
			get
			{
				return _bloodUnitReport;
			}
			set
			{
				_bloodUnitReport = value;
			} 
		}

		#endregion

		#region ControlEvents

		/// <summary>
		/// UncheckAll_Click
		/// </summary>
		private void btnUncheckAll_Click(object sender, System.EventArgs e)
		{
			foreach (object item in this.grpSections.Controls)
			{	
				if(item.GetType().ToString().Equals(_checkBoxType))
				{
					((CheckBox)item).CheckState = CheckState.Unchecked;
				}
			}
			this.CheckValid(sender, e);
		}

		/// <summary>
		/// CheckAll_Click
		/// </summary>
		private void btnCheckAll_Click(object sender, System.EventArgs e)
		{ 
			foreach (object item in this.grpSections.Controls)
			{	
				if(item.GetType().ToString().Equals(_checkBoxType))
				{
					((CheckBox)item).CheckState = CheckState.Checked;
				}
			}
			this.CheckValid(sender, e);
		}

		/// <summary>
		/// CheckValid
		/// </summary>
		private void CheckValid(object sender, System.EventArgs e)
		{
			//this.CheckValid(sender, e);
			this.btnOK.EnabledButton = (this._bloodUnitReport.IsValid && this._bloodUnitReport.ReportsSelected > 0);
		}

		/// <summary>
		/// PrinterName_SelectedIndexChanged
		/// </summary>
		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this._bloodUnitReport.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._bloodUnitReport.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._bloodUnitReport.PrinterName=String.Empty;
				}	
			}
			this.CheckValid(sender, e);
		}

		/// <summary>
		/// ClearBtnClick
		/// </summary>
		private void bloodUnitSelectorVertical1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
			this.IsDirty = false;
			this.EnableReportSelection(false);
			this.CheckValid(sender, e);
		}

		/// <summary>
		/// SearchBtnClick
		/// Implements BR_85.01
		/// </summary>
		private void bloodUnitSelectorVertical1_SearchBtnClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					this.Working();

					DataTable eligDt = BloodUnitReport.GetBloodUnitsForHistoryReport();
					
					// Create a new dialog window and set the required properties...
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
					//
					// BR_85.01
					unitSelector.HighlightInactiveBloodUnits();
					//
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Select Unit for the Report";
					unitSelector.LogoBarText = "Select Unit for the Report";
					unitSelector.ShowDialog(this);
					//
					// If everything went ok, we'll just grab the top row and populate the BloodUnitSelector
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						System.Data.DataRow selectedRow = unitSelector.SelectedUnits.Rows[0];
						this.bloodUnitSelectorVertical1.DisplayBloodUnit(selectedRow[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), selectedRow[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
					}
					eligDt.Dispose();
					eligDt = null;
					this.CheckValid(sender, e);
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
					// A record has been loaded with new values, the initial state of 
					// the page is not dirty.
					this.IsDirty = false;
				}
			}
		}

		/// <summary>
		/// UnitUpdated
		/// </summary>
		private void bloodUnitSelectorVertical1_UnitUpdated(object sender, System.EventArgs e)
		{
			try
			{
				this.EnableReportSelection(true);
				this.GetBloodUnitInfo();
				if(this.BloodUnitReport != null && !this.BloodUnitReport.BloodUnitGuid.Equals(Guid.Empty) && !this.BloodUnitReport.EyeReadableUnitId.Equals(string.Empty))
				{
					this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
				}
				this.CheckValid(sender, e);
				//
				// This flag gets set if the user hits return after 
				// entering a valid unit and product, even though 
				// nothing has been changed yet; so, we set it back
				this.IsDirty = false;
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, err.Message); // **** 508 Compliance ***
				this.ClearControls();
			}
		}

		/// <summary>
		/// Close_Click
		/// </summary>
		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Cancel_Click
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// OK_Click
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			double estimatedRecordCount = BOL.BloodUnitReport.GetReportBloodUnitHistoryRecordCount 
			(
				this._bloodUnitReport.BloodUnitGuid,
				this._bloodUnitReport.IncludeIncomingShipmentReport,
				this._bloodUnitReport.IncludeOutgoingShipmentReport,
				this._bloodUnitReport.IncludeAntigenTypingReport,
				this._bloodUnitReport.IncludeRestrictedPatientReport,
				this._bloodUnitReport.IncludeStatusReport,
				this._bloodUnitReport.IncludeFinanceReport,
				this._bloodUnitReport.IncludePatientAssociationReport,
				this._bloodUnitReport.IncludeIssueReport,
				this._bloodUnitReport.IncludeBloodUnitTestingReport,
				this._bloodUnitReport.IncludeCrossmatchTestingReport,
				this._bloodUnitReport.IncludeModificationReport,
				this._bloodUnitReport.IncludeTransfusionReport,
				this._bloodUnitReport.IncludeExceptionReport
			);
			//
			// estimated records per page = 10
			// add one page to page count for the criteria message
			double recordsPerPage = 10.0d;
			double criteriaPages = 1.0d;
			double pages = estimatedRecordCount == 0.0d ? 0.0d : ( Math.Round(Convert.ToDouble(estimatedRecordCount / recordsPerPage), 1) + criteriaPages );
			//
			if(pages >= 50.0d)
			{
				DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
				if( _result != DialogResult.Yes )
				{
					return;
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
				}
			}
			else if(pages == 0.0d)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
				return;
			}
			//
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void rdoCreateNow_CheckedChanged(object sender, System.EventArgs e)
		{
			this.CheckValid(sender, e); 
		}

		#region Combos CheckChanged

		private void cbIncomingShipment_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeIncomingShipmentReport = this.cbIncomingShipment.Checked;
			this.CheckValid(sender, e);
		}

		private void cbOutgoingShipment_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeOutgoingShipmentReport = this.cbOutgoingShipment.Checked;
			this.CheckValid(sender, e);
		}

		private void cbAntigenTyping_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeAntigenTypingReport = this.cbAntigenTyping.Checked;
			this.CheckValid(sender, e);
		}

		private void cbRestrictedPatient_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeRestrictedPatientReport = this.cbRestrictedPatient.Checked;
			this.CheckValid(sender, e);
		}

		private void cbUnitStatus_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeStatusReport = this.cbUnitStatus.Checked;
			this.CheckValid(sender, e);
		}

		private void cbFinance_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeFinanceReport = this.cbFinance.Checked;
			this.CheckValid(sender, e);
		}

		private void cbPatientAssociation_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludePatientAssociationReport = this.cbPatientAssociation.Checked;
			this.CheckValid(sender, e);
		}

		private void cbIssue_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeIssueReport = this.cbIssue.Checked;
			this.CheckValid(sender, e);
		}

		private void cbUnitTesting_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeBloodUnitTestingReport = this.cbUnitTesting.Checked;
			this.CheckValid(sender, e);
		}

		private void cbCrossmatchTesting_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeCrossmatchTestingReport = this.cbCrossmatchTesting.Checked;
			this.CheckValid(sender, e);
		}

		private void cbModification_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeModificationReport = this.cbModification.Checked;
			this.CheckValid(sender, e);
		}

		private void cbTransfusion_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeTransfusionReport = this.cbTransfusion.Checked;
			this.CheckValid(sender, e);
		}

		private void cbExceptionReport_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BloodUnitReport.IncludeExceptionReport = this.cbExceptionReport.Checked;
			this.CheckValid(sender, e);
		}

		#endregion

		#endregion

		#region Constructors/ Destructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgUnitDataReportCriteria()
		{
			this._bloodUnitReport=new BloodUnitReport();

			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Methods

		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpScheduleJob.Enabled=rdoScheduleJob.Checked;
			this._bloodUnitReport.IsScheduled=rdoScheduleJob.Checked;
			if ((this._bloodUnitReport.IsScheduled) && (this.dtpPrintDate.Value != this._bloodUnitReport.PrintDate))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
			this.CheckValid(sender, e);
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (this._bloodUnitReport.IsScheduled)
			{
				this._bloodUnitReport.PrintDate=this.dtpPrintDate.Value;
			}
			this.CheckValid(sender, e);
		}

		/// <summary>
		/// GetBloodUnitInfo
		/// </summary>
		private void GetBloodUnitInfo()
		{
			this.BloodUnitReport = new BloodUnitReport(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);
			this._bloodUnitReport.EyeReadableUnitId = this.bloodUnitSelectorVertical1.SelectedBloodUnit.EyeReadableUnitId;
			this._bloodUnitReport.ProductCode = this.bloodUnitSelectorVertical1.SelectedBloodUnit.ProductCode;
			this.BloodUnitReport.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this.GetSelectedReports();
			this.EnableReportSelection(true);
			this._bloodUnitReport.SetInitialBrokenRules(Common.VbecsBrokenRules.ProlongedTransfusionReport.FormClassName, Common.VbecsBrokenRules.ProlongedTransfusionReport.RuleSets.BaseRuleSet);
		}

		/// <summary>
		/// GetSelectedReports
		/// </summary>
		private void GetSelectedReports()
		{
			this._bloodUnitReport.IncludeAntigenTypingReport = this.cbAntigenTyping.Checked;
			this._bloodUnitReport.IncludeCrossmatchTestingReport = this.cbCrossmatchTesting.Checked;
			this._bloodUnitReport.IncludeRestrictedPatientReport = this.cbRestrictedPatient.Checked;
			this._bloodUnitReport.IncludeExceptionReport = this.cbExceptionReport.Checked;
			this._bloodUnitReport.IncludeFinanceReport = this.cbFinance.Checked;
			this._bloodUnitReport.IncludeIncomingShipmentReport = this.cbIncomingShipment.Checked;
			this._bloodUnitReport.IncludeIssueReport = this.cbIssue.Checked;
			this._bloodUnitReport.IncludeModificationReport = this.cbModification.Checked;
			this._bloodUnitReport.IncludeOutgoingShipmentReport = this.cbOutgoingShipment.Checked;
			this._bloodUnitReport.IncludePatientAssociationReport = this.cbPatientAssociation.Checked;
			this._bloodUnitReport.IncludeTransfusionReport = this.cbTransfusion.Checked;
			this._bloodUnitReport.IncludeStatusReport = this.cbUnitStatus.Checked;
			this._bloodUnitReport.IncludeBloodUnitTestingReport = this.cbUnitTesting.Checked;
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = AdditionalBloodUnitSearchCriteria.InactiveUnits;
			//
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC085.DlgUnitDataReportCriteria());
			//
			this.btnOK.EnabledButton = true;
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.EnableReportSelection(false);
			//
			this.cmbPrinterName.Items.Clear();
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			//set current date value based on the division time zone
			this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}

			this._bloodUnitReport.Valid += new System.EventHandler(this.CheckValid);
			this._bloodUnitReport.Invalid += new System.EventHandler(this.CheckValid);
			this._bloodUnitReport.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._bloodUnitReport.SetInitialBrokenRules(Common.VbecsBrokenRules.ProlongedTransfusionReport.FormClassName, Common.VbecsBrokenRules.ProlongedTransfusionReport.RuleSets.BaseRuleSet);
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void EnableReportSelection(bool flag)
		{
			this.btnOK.EnabledButton = flag;

			this.cbAntigenTyping.Enabled = flag;
			this.cbCrossmatchTesting.Enabled = flag;
			this.cbRestrictedPatient.Enabled = flag;
			this.cbExceptionReport.Enabled = flag;
			this.cbFinance.Enabled = flag;
			this.cbIncomingShipment.Enabled = flag;
			this.cbIssue.Enabled = flag;
			this.cbModification.Enabled = flag;
			this.cbOutgoingShipment.Enabled = flag;
			this.cbPatientAssociation.Enabled = flag;
			this.cbTransfusion.Enabled = flag;
			this.cbUnitStatus.Enabled = flag;
			this.cbUnitTesting.Enabled = flag;

			this.btnCheckAll.Enabled = flag;
			this.btnUncheckAll.Enabled = flag;
		}

		/// <summary>
		/// ClearControls
		/// </summary>
		private void ClearControls()
		{
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = false;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = false;
		}

		#endregion
	}
}
